<?php

namespace App\Components\Gateways;

use Exception;
use Carbon\Carbon;
use App\Models\Plan;
use Razorpay\Api\Api;
use Illuminate\Http\Request;
use App\Contracts\GatewayInterface;

class RazorPay implements GatewayInterface
{
    protected $request;
    protected $config;
    protected $razorpay;

    public function __construct(Request $request, array $config)
    {
        $this->request = $request;
        $this->config = $config;
    }

    public function isActive(): bool
    {
        return (bool) setting('razor_allow', 0);
    }

    public function isConfigured(): bool
    {
        return (!empty(config('services.gateways.razorpay.key')) && !empty(config('services.gateways.razorpay.secret')));
    }

    public function getName(): string
    {
        return "Razorpay";
    }

    public function getIcon(): string
    {
        return '<svg width="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 578 512">
<path d="M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6
	C155.7,239.7,155.4,237.5,153.9,236z M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1
	s3.9-3.6,4.7-6.6C155.7,239.7,155.4,237.5,153.9,236z M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3
	c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6C155.7,239.7,155.4,237.5,153.9,236z M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6
	s-6.6,1.3-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6
	c2.5-2.4,4.4-5.9,5.6-10.4S205.2,257.8,203.9,255.2z M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.3-9.2,3.8
	c-2.6,2.6-4.5,6-5.7,10.5c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.4,4.4-5.9,5.6-10.4
	S205.2,257.8,203.9,255.2z M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6
	C155.7,239.7,155.4,237.5,153.9,236z M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1
	s3.9-3.6,4.7-6.6C155.7,239.7,155.4,237.5,153.9,236z M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.3-9.2,3.8
	c-2.6,2.6-4.5,6-5.7,10.5c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.4,4.4-5.9,5.6-10.4
	S205.2,257.8,203.9,255.2z M310.8,255c-1.2-2.3-3.6-3.5-7.1-3.5s-6.6,1.1-9.1,3.5c-2.5,2.3-4.4,5.9-5.6,10.5c-2.6,9.3-0.2,14,7.2,14
	c3.5,0,6.5-1.2,9-3.5s4.3-5.8,5.6-10.5C312,261,312,257.5,310.8,255z M310.8,255c-1.2-2.3-3.6-3.5-7.1-3.5s-6.6,1.1-9.1,3.5
	c-2.5,2.3-4.4,5.9-5.6,10.5c-2.6,9.3-0.2,14,7.2,14c3.5,0,6.5-1.2,9-3.5s4.3-5.8,5.6-10.5C312,261,312,257.5,310.8,255z
	 M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.3-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5c-1.2,4.4-1.2,7.8,0.1,10.2
	c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.4,4.4-5.9,5.6-10.4S205.2,257.8,203.9,255.2z M153.9,236
	c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6C155.7,239.7,155.4,237.5,153.9,236z
	 M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6
	C155.7,239.7,155.4,237.5,153.9,236z M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.3-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5
	c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.4,4.4-5.9,5.6-10.4S205.2,257.8,203.9,255.2z
	 M310.8,255c-1.2-2.3-3.6-3.5-7.1-3.5s-6.6,1.1-9.1,3.5c-2.5,2.3-4.4,5.9-5.6,10.5c-2.6,9.3-0.2,14,7.2,14c3.5,0,6.5-1.2,9-3.5
	s4.3-5.8,5.6-10.5C312,261,312,257.5,310.8,255z M408.4,255.2c-1.2-2.5-3.5-3.7-7-3.7s-6.5,1.2-9.1,3.6c-2.6,2.4-4.5,5.9-5.7,10.4
	c-1.2,4.6-1.2,8,0.1,10.4c1.3,2.4,3.6,3.6,7.2,3.6c3.6,0,6.6-1.1,9.1-3.5c2.5-2.3,4.4-5.7,5.6-10.2
	C409.8,261.3,409.8,258,408.4,255.2z M465.7,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.2-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5
	c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.3,4.4-5.8,5.6-10.3S467,257.7,465.7,255.2z
	 M465.7,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.2-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5c-1.2,4.4-1.2,7.8,0.1,10.2
	c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.3,4.4-5.8,5.6-10.3S467,257.7,465.7,255.2z M408.4,255.2
	c-1.2-2.5-3.5-3.7-7-3.7s-6.5,1.2-9.1,3.6c-2.6,2.4-4.5,5.9-5.7,10.4c-1.2,4.6-1.2,8,0.1,10.4c1.3,2.4,3.6,3.6,7.2,3.6
	c3.6,0,6.6-1.1,9.1-3.5c2.5-2.3,4.4-5.7,5.6-10.2C409.8,261.3,409.8,258,408.4,255.2z M310.8,255c-1.2-2.3-3.6-3.5-7.1-3.5
	s-6.6,1.1-9.1,3.5c-2.5,2.3-4.4,5.9-5.6,10.5c-2.6,9.3-0.2,14,7.2,14c3.5,0,6.5-1.2,9-3.5s4.3-5.8,5.6-10.5
	C312,261,312,257.5,310.8,255z M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.3-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5
	c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.4,4.4-5.9,5.6-10.4S205.2,257.8,203.9,255.2z
	 M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6
	C155.7,239.7,155.4,237.5,153.9,236z M557,32H21.1C9.5,32,0,41.5,0,53.1v405.7C0,470.5,9.5,480,21.1,480h535.8
	c11.6,0,21.1-9.5,21.1-21V53.1C578,41.5,568.5,32,557,32z M33,289.7l6.7-25l40.1-25.8l-13.6,50.8H33z M70.2,289.8l15.9-59.5
	L61.7,246l4.3-15.7l43.9-28.3l-23.5,87.8H70.2z M156.5,269l2.5,20.8h-15.5l-2.6-22.3c-0.3-1.8-1-3-2.2-3.7s-2.9-1-5-1h-9.5l-7.2,27
	h-14.5l18-67.1h29.9c7.7,0,13.2,1.7,16.3,5.1c3.1,3.4,3.8,8.3,2.1,14.6c-1.1,4.3-3.4,8.3-6.7,11.5c-3.3,3.2-7.2,5.5-12,6.9
	C153.9,261.5,156,264.3,156.5,269z M197.6,289.8l1.9-7.1c-2.1,2.4-4.8,4.4-7.7,5.7c-3,1.4-6.2,2.1-9.5,2.1c-4.2,0-7.6-1-10.2-3
	c-2.6-2-4.3-4.9-5.1-8.6c-0.8-3.7-0.5-8,0.8-12.9c1.3-4.9,3.4-9.3,6.2-13.1c2.9-3.8,6.2-6.8,9.9-8.9c3.8-2.2,7.7-3.2,11.8-3.2
	c3.4,0,6.1,0.8,8.4,2.2c2.2,1.4,3.7,3.4,4.5,5.8l1.8-6.8h14.1l-12.9,47.8H197.6z M265.8,279l-2.8,10.6h-42.1l2.7-10l31.4-27.1h-23.7
	l2.8-10.6h40.8l-2.7,9.6L240.4,279H265.8z M324.8,265.5c-1.4,5-3.5,9.4-6.6,13.2c-3,3.8-6.7,6.7-11,8.7s-9,3-14,3
	c-5.1,0-9.2-1-12.5-3c-3.2-1.9-5.4-4.9-6.4-8.6c-1-3.8-0.8-8.2,0.5-13.2c1.4-5,3.5-9.5,6.6-13.2c3-3.7,6.8-6.7,11.1-8.7s9-3,14.1-3
	c5,0,9.2,1,12.4,3l-0.1-0.1c3.2,2,5.4,5,6.4,8.7C326.3,256.2,326.2,260.5,324.8,265.5z M347.8,264.7l-6.7,25h-14.2l12.9-47.7h14.1
	l-1.9,7c1.9-2.4,4-4.3,6.6-5.7c3-1.6,6.1-2.4,9.3-2.4c2,0,3.6,0.3,4.8,0.9l-3.6,13c-2.1-1.1-4.3-1.6-6.7-1.7c-3.7,0-6.9,1.1-9.4,3.1
	S348.8,261,347.8,264.7z M422.8,265.8c-1.3,4.9-3.4,9.2-6.1,12.9s-6,6.6-9.7,8.6s-7.7,3-11.8,3c-3.3,0-6.1-0.7-8.4-2.1
	s-3.8-3.3-4.5-5.7l-7.4,27.4h-14.2l14.5-54.3l0.1-0.5l3.5-13.2h13.9l-2.4,7.6v0.3c2-2.8,4.7-5,7.9-6.7c3.2-1.7,6.6-2.5,10.2-2.5
	c4.1,0,7.5,1.1,10.1,3.2c2.7,2.1,4.4,5.1,5.1,8.9C424.4,256.5,424.1,261,422.8,265.8z M459.3,289.8l1.9-7.1
	c-2.1,2.4-4.8,4.4-7.7,5.7c-3,1.4-6.2,2.1-9.5,2.1c-4.2,0-7.6-1-10.2-3c-2.6-2-4.3-4.9-5.1-8.6c-0.8-3.8-0.5-8.1,0.8-13
	c1.3-4.9,3.4-9.3,6.2-13.1c2.9-3.8,6.2-6.8,9.9-8.9c3.8-2.2,7.7-3.2,11.8-3.2c3.3,0,6.1,0.8,8.4,2.2c2.2,1.4,3.7,3.4,4.5,5.8
	l1.8-6.8h14l-12.8,47.9H459.3z M527.2,267L506.1,297l-0.1,0.2l-4.7,6.7c-0.1,0.2-0.2,0.3-0.3,0.5l-4,5.7h-14.9l16.7-23l-7.5-45.1
	h14.9l3.7,29.7l18.2-25.3l0.2-0.4l0.6-0.8l2.3-3.2H545L527.2,267z M458.6,251.5c-3.5,0-6.6,1.2-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5
	c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.3,4.4-5.8,5.6-10.3s1.2-8-0.1-10.5
	C464.5,252.8,462.1,251.5,458.6,251.5z M401.4,251.5c-3.5,0-6.5,1.2-9.1,3.6c-2.6,2.4-4.5,5.9-5.7,10.4c-1.2,4.6-1.2,8,0.1,10.4
	c1.3,2.4,3.6,3.6,7.2,3.6c3.6,0,6.6-1.1,9.1-3.5c2.5-2.3,4.4-5.7,5.6-10.2c1.2-4.5,1.2-7.9-0.2-10.6
	C407.2,252.8,404.9,251.5,401.4,251.5z M303.7,251.5c-3.5,0-6.6,1.1-9.1,3.5c-2.5,2.3-4.4,5.9-5.6,10.5c-2.6,9.3-0.2,14,7.2,14
	c3.5,0,6.5-1.2,9-3.5s4.3-5.8,5.6-10.5c1.2-4.6,1.2-8.1,0-10.5C309.6,252.8,307.2,251.5,303.7,251.5z M196.8,251.7
	c-3.5,0-6.6,1.3-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6
	c2.5-2.4,4.4-5.9,5.6-10.4s1.2-7.9-0.1-10.4C202.7,252.8,200.3,251.7,196.8,251.7z M145.2,233.8h-13.4l-4.7,17.5h13.3
	c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6c0.8-3,0.5-5.2-1-6.7C152.3,234.5,149.4,233.8,145.2,233.8z M153.9,236
	c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6C155.7,239.7,155.4,237.5,153.9,236z
	 M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.3-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5c-1.2,4.4-1.2,7.8,0.1,10.2
	c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.4,4.4-5.9,5.6-10.4S205.2,257.8,203.9,255.2z M310.8,255
	c-1.2-2.3-3.6-3.5-7.1-3.5s-6.6,1.1-9.1,3.5c-2.5,2.3-4.4,5.9-5.6,10.5c-2.6,9.3-0.2,14,7.2,14c3.5,0,6.5-1.2,9-3.5
	s4.3-5.8,5.6-10.5C312,261,312,257.5,310.8,255z M408.4,255.2c-1.2-2.5-3.5-3.7-7-3.7s-6.5,1.2-9.1,3.6c-2.6,2.4-4.5,5.9-5.7,10.4
	c-1.2,4.6-1.2,8,0.1,10.4c1.3,2.4,3.6,3.6,7.2,3.6c3.6,0,6.6-1.1,9.1-3.5c2.5-2.3,4.4-5.7,5.6-10.2
	C409.8,261.3,409.8,258,408.4,255.2z M408.4,255.2c-1.2-2.5-3.5-3.7-7-3.7s-6.5,1.2-9.1,3.6c-2.6,2.4-4.5,5.9-5.7,10.4
	c-1.2,4.6-1.2,8,0.1,10.4c1.3,2.4,3.6,3.6,7.2,3.6c3.6,0,6.6-1.1,9.1-3.5c2.5-2.3,4.4-5.7,5.6-10.2
	C409.8,261.3,409.8,258,408.4,255.2z M310.8,255c-1.2-2.3-3.6-3.5-7.1-3.5s-6.6,1.1-9.1,3.5c-2.5,2.3-4.4,5.9-5.6,10.5
	c-2.6,9.3-0.2,14,7.2,14c3.5,0,6.5-1.2,9-3.5s4.3-5.8,5.6-10.5C312,261,312,257.5,310.8,255z M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6
	s-6.6,1.3-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6
	c2.5-2.4,4.4-5.9,5.6-10.4S205.2,257.8,203.9,255.2z M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3
	c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6C155.7,239.7,155.4,237.5,153.9,236z M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5
	h13.3c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6C155.7,239.7,155.4,237.5,153.9,236z M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6
	s-6.6,1.3-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6
	c2.5-2.4,4.4-5.9,5.6-10.4S205.2,257.8,203.9,255.2z M310.8,255c-1.2-2.3-3.6-3.5-7.1-3.5s-6.6,1.1-9.1,3.5
	c-2.5,2.3-4.4,5.9-5.6,10.5c-2.6,9.3-0.2,14,7.2,14c3.5,0,6.5-1.2,9-3.5s4.3-5.8,5.6-10.5C312,261,312,257.5,310.8,255z M310.8,255
	c-1.2-2.3-3.6-3.5-7.1-3.5s-6.6,1.1-9.1,3.5c-2.5,2.3-4.4,5.9-5.6,10.5c-2.6,9.3-0.2,14,7.2,14c3.5,0,6.5-1.2,9-3.5
	s4.3-5.8,5.6-10.5C312,261,312,257.5,310.8,255z M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.3-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5
	c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.4,4.4-5.9,5.6-10.4S205.2,257.8,203.9,255.2z
	 M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6
	C155.7,239.7,155.4,237.5,153.9,236z M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1
	s3.9-3.6,4.7-6.6C155.7,239.7,155.4,237.5,153.9,236z M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.3-9.2,3.8
	c-2.6,2.6-4.5,6-5.7,10.5c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.4,4.4-5.9,5.6-10.4
	S205.2,257.8,203.9,255.2z M203.9,255.2c-1.2-2.4-3.6-3.6-7.1-3.6s-6.6,1.3-9.2,3.8c-2.6,2.6-4.5,6-5.7,10.5
	c-1.2,4.4-1.2,7.8,0.1,10.2c1.3,2.3,3.7,3.5,7.3,3.5c3.6,0,6.6-1.2,9.1-3.6c2.5-2.4,4.4-5.9,5.6-10.4S205.2,257.8,203.9,255.2z
	 M153.9,236c-1.6-1.4-4.5-2.1-8.7-2.1h-13.4l-4.7,17.5h13.3c4.2,0,7.5-0.7,9.8-2.1s3.9-3.6,4.7-6.6
	C155.7,239.7,155.4,237.5,153.9,236z"/>
</svg>

';
    }

    public function getViewName()
    {
        return "checkout.razorpay";
    }

    public function initialize()
    {
        $this->razorpay = new Api(config('services.gateways.razorpay.key'), config('services.gateways.razorpay.secret'));
    }

    public function render()
    {
        return view('checkout.razorpay')->render();
    }

    public function processPayment($transaction)
    {
        $request = $this->request;
        $plan_id = $request->plan_id;
        if ($plan_id == 0) {
            $plan = ads_plan();
        } else {
            $plan = Plan::find($request->plan_id); //get from plan db
        }

        if ($request->type == "yearly") {
            $amount = $plan->yearly_price;
            $var_type = "addAnnualPlan";
        } else {
            $amount = $plan->monthly_price;
            $var_type = "addMonthlyPlan";
        }

        try {
            $input = $request->all();



            $payment = $this->razorpay->payment->fetch($request->razor_pay_id);

            if (count($input)  && !empty($request->razor_pay_id)) {
                try {
                    $amount = $amount * 100;
                    $response = $this->razorpay->payment->fetch($request->razor_pay_id)->capture(array('amount' => (float) number_format((float)$amount, 2, '.', '')));
                } catch (Exception $e) {
                    return redirect()->back()->withErrors($e->getMessage());
                }
            }

            if (isset($request->razor_pay_id)) {
                $transaction->transaction_id = $request->razor_pay_id; // update the transaction id for the database
                $transaction->update();
                return redirect()->route("payments.success", $transaction->id);
            } else {
                return redirect()->route("payments.cancel", $transaction->id);
            }
        } catch (\Exception $e) {
            return redirect()->back()->withError($e->getMessage());
        }
    }

    public function verifyPayment($transaction, $request): bool
    {
        return true;
    }
}
